<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\User\EmailVerification;

trait TraitUserEmailVerificationSetters
{
    use TraitUserEmailVerificationProperties;

    /**
     * @return static 
     */
    final public function setId(string $id)
    {
        $this -> id = $id;

        return $this;
    }

    /**
     * @return static 
     */
    final public function setUserId(string $userId)
    {
        $this -> userId = $userId;

        return $this;
    }

    /**
     * @return static 
     */
    final public function setMetaAccessOTP(string $metaAccessOTP)
    {
        $this -> metaAccessOTP = $metaAccessOTP;

        return $this;
    }

    /**
     * @return static 
     */
    final public function setMetaTimesFailed(string $metaTimesFailed)
    {
        $this -> metaTimesFailed = $metaTimesFailed;

        return $this;
    }

    /**
     * @return static 
     */
    final public function setMetaIsExpired(string $metaIsExpired)
    {
        $this -> metaIsExpired = $metaIsExpired;

        return $this;
    }

    /**
     * @return static 
     */
    public function setStampRegistration(string $stampRegistration)
    {
        $this -> stampRegistration = $stampRegistration;

        return $this;
    }

    /**
     * @return static 
     */
    public function setStampLastUpdate(string $stampLastUpdate)
    {
        $this -> stampLastUpdate = $stampLastUpdate;

        return $this;
    }
}
